/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.turtle;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.shared.util.RegistryHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4590;
import net.minecraft.class_9326;

@Environment(value=EnvType.CLIENT)
public final class TurtleUpgradeModellers {
    private static final TurtleUpgradeModeller<ITurtleUpgrade> NULL_TURTLE_MODELLER = (upgrade, turtle, side, data) -> new TransformedModel(class_310.method_1551().method_1554().method_4744(), class_4590.method_22931());
    private static final Map<UpgradeType<? extends ITurtleUpgrade>, TurtleUpgradeModeller<?>> turtleModels = new ConcurrentHashMap();
    private static volatile boolean fetchedModels;

    private TurtleUpgradeModellers() {
    }

    public static <T extends ITurtleUpgrade> void register(UpgradeType<T> type, TurtleUpgradeModeller<T> modeller) {
        if (fetchedModels) {
            throw new IllegalStateException(String.format("Turtle upgrade type %s must be registered before models are baked.", RegistryHelper.getKeyOrThrow(RegistryHelper.getRegistry(ITurtleUpgrade.typeRegistry()), type)));
        }
        if (turtleModels.putIfAbsent(type, modeller) != null) {
            throw new IllegalStateException("Modeller already registered for serialiser");
        }
    }

    public static TransformedModel getModel(ITurtleUpgrade upgrade, ITurtleAccess access, TurtleSide side) {
        return TurtleUpgradeModellers.getModeller(upgrade).getModel(upgrade, access, side, access.getUpgradeData(side));
    }

    public static TransformedModel getModel(ITurtleUpgrade upgrade, class_9326 data, TurtleSide side) {
        return TurtleUpgradeModellers.getModeller(upgrade).getModel(upgrade, null, side, data);
    }

    private static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> getModeller(T upgrade) {
        TurtleUpgradeModeller<?> modeller = turtleModels.get(upgrade.getType());
        return modeller == null ? NULL_TURTLE_MODELLER : modeller;
    }

    public static Stream<class_2960> getDependencies() {
        fetchedModels = true;
        return turtleModels.values().stream().flatMap(TurtleUpgradeModeller::getDependencies);
    }
}

